#Comments

This solution uses requests package. Unfortunately requests do not provide coroutines nonblocking
coroutines. If we called requests.get while running asyncio, our thread would stop and wait for 
the request to finish. This would ruin any parallelism If we really need to have some blocking 
call, we nedd to do it in a separate thread. It is good idea to fix the number of threads and 
recycle them. From the technical point of view, everything is as in the wiki_game.py example 
from here:
http://www.dcs.fmph.uniba.sk/~lukotka/PTS/15Examples.zip

Besides this approach one could use packages like aiohttp (or there is ever aiohttp-requests,
but I do not know the state of the project). This solution is more efficient. The reason 
my solution uses requests is
1. Keep it within the staf we had in the lectures and the examples
2. Educational aspects of using an executor thread pool and threads.

Using standard OO design principles we separated threading and requests so that we have control
over how it composes using dependency injection. This allows us to write tests as we need.

Another solution is to use patch decorator from unittest.mock. This allows us to mock a any 
function and thus we can handle fixed (non injected) dependencies. This approach should be used 
really carefully (as with many dynamic aspects of Python), because things may become really 
messy easily Buit for testing purposes, patching is completely fine. The only objection to 
this approach is that this knowledge is non-transferable to many other programming languages.
So it is more important to master the standard dependency inversion approach.

